/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.dimension;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import earth.terrarium.adastra.client.dimension.ModDimensionSpecialEffects;
import earth.terrarium.adastra.client.dimension.MovementType;
import earth.terrarium.adastra.client.dimension.PlanetRenderer;
import earth.terrarium.adastra.client.utils.DimensionRenderingUtils;
import earth.terrarium.adastra.mixins.client.LevelRendererAccessor;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5636;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_6008;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ModSkyRenderer {
    private final PlanetRenderer renderer;
    @Nullable
    private class_291 starBuffer;

    public ModSkyRenderer(PlanetRenderer renderer) {
        this.renderer = renderer;
    }

    public void render(class_638 level, float partialTick, class_4587 poseStack, class_4184 camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        setupFog.run();
        if (isFoggy || this.inFog(camera)) {
            return;
        }
        if (!this.renderer.renderInRain() && level.method_8419()) {
            return;
        }
        if (this.starBuffer == null) {
            this.createStars();
        }
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        this.setSkyColor(level, camera, partialTick);
        RenderSystem.depthMask((boolean)false);
        class_291.method_1354();
        RenderSystem.enableBlend();
        this.renderSky(bufferBuilder, level, partialTick, poseStack, projectionMatrix);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        poseStack.method_22903();
        this.renderStars(level, partialTick, poseStack, projectionMatrix, setupFog);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderer.skyRenderables().forEach(renderable -> {
            class_243 globalRotation = switch (renderable.movementType()) {
                default -> throw new IncompatibleClassChangeError();
                case MovementType.STATIC -> renderable.globalRotation();
                case MovementType.TIME_OF_DAY -> renderable.globalRotation().method_1031(0.0, 0.0, (double)(level.method_30274(partialTick) * 360.0f));
                case MovementType.TIME_OF_DAY_REVERSED -> renderable.globalRotation().method_1031(0.0, 0.0, (double)(-level.method_30274(partialTick) * 360.0f));
            };
            this.renderSkyRenderable(bufferBuilder, poseStack, renderable.localRotation(), globalRotation, renderable.scale(), renderable.texture(), renderable.blend());
            if (renderable.backLightScale() > 0.0f) {
                this.setSkyRenderableColor(level, partialTick, renderable.backLightColor());
                this.renderSkyRenderable(bufferBuilder, poseStack, renderable.localRotation(), globalRotation, renderable.backLightScale(), DimensionRenderingUtils.BACKLIGHT, true);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        });
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.method_22909();
        RenderSystem.depthMask((boolean)true);
    }

    public boolean inFog(class_4184 camera) {
        LevelRendererAccessor levelRenderer = (LevelRendererAccessor)class_310.method_1551().field_1769;
        class_5636 fogType = camera.method_19334();
        return fogType == class_5636.field_27887 || fogType == class_5636.field_27885 || levelRenderer.invokeDoesMobEffectBlockSky(camera);
    }

    public void setSkyColor(class_638 level, class_4184 camera, float partialTick) {
        class_243 skyColor = level.method_23777(camera.method_19326(), partialTick);
        float r = (float)skyColor.field_1352;
        float g = (float)skyColor.field_1351;
        float b = (float)skyColor.field_1350;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
    }

    public void renderSky(class_287 bufferBuilder, class_638 level, float partialTick, class_4587 poseStack, Matrix4f projectionMatrix) {
        class_758.method_3212();
        class_5944 shader = RenderSystem.getShader();
        if (shader == null) {
            return;
        }
        class_291 skyBuffer = ((LevelRendererAccessor)class_310.method_1551().field_1769).getSkyBuffer();
        skyBuffer.method_1353();
        skyBuffer.method_34427(poseStack.method_23760().method_23761(), projectionMatrix, shader);
        class_291.method_1354();
        RenderSystem.enableBlend();
        float[] color = ModDimensionSpecialEffects.getSunriseColor(level.method_30274(partialTick), partialTick, this.renderer.sunriseColor());
        if (color != null) {
            this.renderSunrise(bufferBuilder, level, partialTick, poseStack, color);
        }
    }

    public void renderSunrise(class_287 bufferBuilder, class_638 level, float partialTick, class_4587 poseStack, float[] color) {
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)this.renderer.sunriseAngle()));
        float sunAngle = class_3532.method_15374((float)level.method_8442(partialTick)) < 0.0f ? 180.0f : 0.0f;
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(sunAngle));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
        float r = color[0];
        float g = color[1];
        float b = color[2];
        Matrix4f matrix = poseStack.method_23760().method_23761();
        bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        bufferBuilder.method_22918(matrix, 0.0f, 100.0f, 0.0f).method_22915(r, g, b, color[3]).method_1344();
        for (int i = 0; i <= 16; ++i) {
            float angle = (float)i * ((float)Math.PI * 2) / 16.0f;
            float x = class_3532.method_15374((float)angle);
            float y = class_3532.method_15362((float)angle);
            bufferBuilder.method_22918(matrix, x * 120.0f, y * 120.0f, -y * 40.0f * color[3]).method_22915(r, g, b, 0.0f).method_1344();
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        poseStack.method_22909();
    }

    public void renderSkyRenderable(class_287 bufferBuilder, class_4587 poseStack, class_243 localRotation, class_243 globalRotation, float scale, class_2960 texture, boolean blend) {
        if (blend) {
            RenderSystem.enableBlend();
        }
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40714.rotationDegrees((float)globalRotation.field_1352));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)globalRotation.field_1351));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)globalRotation.field_1350));
        poseStack.method_46416(0.0f, 100.0f, 0.0f);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees((float)localRotation.field_1352));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)localRotation.field_1351));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)localRotation.field_1350));
        poseStack.method_46416(0.0f, -100.0f, 0.0f);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, -scale, 100.0f, -scale).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, scale, 100.0f, -scale).method_22913(0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, scale, 100.0f, scale).method_22913(0.0f, 1.0f).method_1344();
        bufferBuilder.method_22918(matrix, -scale, 100.0f, scale).method_22913(1.0f, 1.0f).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        poseStack.method_22909();
        RenderSystem.disableBlend();
    }

    public void setSkyRenderableColor(class_638 level, float partialTick, int color) {
        float r = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float b = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        float a = this.renderer.renderInRain() ? 1.0f : 1.0f - level.method_8430(partialTick);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public void renderStars(class_638 level, float partialTick, class_4587 poseStack, Matrix4f projectionMatrix, Runnable setupFog) {
        float starLight = this.renderer.starBrightness().orElseGet(() -> {
            float rainLevel = 1.0f - level.method_8430(partialTick);
            return Float.valueOf(level.method_23787(partialTick) * rainLevel);
        }).floatValue();
        if (starLight <= 0.0f) {
            return;
        }
        if (this.starBuffer == null) {
            return;
        }
        RenderSystem.setShaderColor((float)starLight, (float)starLight, (float)starLight, (float)starLight);
        class_758.method_23792();
        this.starBuffer.method_1353();
        class_5944 shader = class_757.method_34540();
        if (shader == null) {
            return;
        }
        this.starBuffer.method_34427(poseStack.method_23760().method_23761(), projectionMatrix, shader);
        class_291.method_1354();
        setupFog.run();
    }

    public void createStars() {
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new class_291(class_291.class_8555.field_44793);
        class_287.class_7433 renderedBuffer = this.drawStars(bufferBuilder);
        this.starBuffer.method_1353();
        this.starBuffer.method_1352(renderedBuffer);
        class_291.method_1354();
    }

    public class_287.class_7433 drawStars(class_287 builder) {
        class_5819 random = class_5819.method_43049((long)10842L);
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        for (int i = 0; i < this.renderer.stars(); ++i) {
            double x = random.method_43057() * 2.0f - 1.0f;
            double y = random.method_43057() * 2.0f - 1.0f;
            double z = random.method_43057() * 2.0f - 1.0f;
            double scale = 0.15 + (double)random.method_43057() * 0.1;
            double distance = x * x + y * y + z * z;
            if (distance >= 1.0 || distance <= 0.01) continue;
            distance = 1.0 / Math.sqrt(distance);
            double xScale = (x *= distance) * 100.0;
            double yScale = (y *= distance) * 100.0;
            double zScale = (z *= distance) * 100.0;
            double theta = Math.atan2(x, z);
            double sinTheta = Math.sin(theta);
            double cosTheta = Math.cos(theta);
            double phi = Math.atan2(Math.sqrt(x * x + z * z), y);
            double sinPhi = Math.sin(phi);
            double cosPhi = Math.cos(phi);
            double rot = random.method_43058() * Math.PI * 2.0;
            double sinRot = Math.sin(rot);
            double cosRot = Math.cos(rot);
            int color = this.renderer.starColors().method_34992(random).map(class_6008.class_6010::method_34983).orElse(-1);
            for (int j = 0; j < 4; ++j) {
                double xOffset = (double)((j & 2) - 1) * scale;
                double yOffset = (double)((j + 1 & 2) - 1) * scale;
                double rotatedX = xOffset * cosRot - yOffset * sinRot;
                double rotatedY = yOffset * cosRot + xOffset * sinRot;
                double transformedX = rotatedX * sinPhi;
                double transformedY = -rotatedX * cosPhi;
                builder.method_22912(xScale + transformedY * sinTheta - rotatedY * cosTheta, yScale + transformedX, zScale + rotatedY * sinTheta + transformedY * cosTheta).method_39415(color).method_1344();
            }
        }
        return builder.method_1326();
    }
}

